dofile(LockOn_Options.common_script_path..'wsTypes_SAM.lua')
dofile(LockOn_Options.common_script_path..'wsTypes_Airplane.lua')
dofile(LockOn_Options.common_script_path..'wsTypes_Ship.lua')
dofile(LockOn_Options.common_script_path..'wsTypes_Missile.lua')

local gettext = require("i_18n")
_ = gettext.translate

device_timer_dt     = 0.2
MaxThreats          = 16
EmitterLiveTime     = 7.0
EmitterSoundTime    = 0.5
LaunchSoundDelay    = 15.0

DefaultType          = 100

RWR_detection_coeff = 0.85

DEFAULT_TYPE_ = {DefaultType, DefaultType, DefaultType, DefaultType}

symbols = 
{
    {MiG_23_,       "23"},
    {MiG_29_,       "29"},
    {MIG_29K_,      "29"},
    {MiG_29G_,      "29"},
    {MiG_29C_,      "29"},
    {Su_27_,        "29"},
    {Su_33_,        "29"},
    {F_14_,         "14"},
    {F_15_,         "15"},
    {F_16_,         "16"},
    {F_16A_,        "16"},
    {F_2_,          "F2"},
    {Su_30_,        "30"},
    {FA_18_,        "18"},
    {FA_18C_,       "18"},
    {Su_34_,        "34"},
    {Mirage_,       "M2"},
    {F_4E_,         "F4"},
    {F_5E_,         "F5"},
    {Su_24_,        "24"},
    {Su_24MR_,      "24"},
    {AV_8B_,        "AV"},
    {EA_6B_,        "E6"},
    {F_111_,        "11"},
    {Tu_160_,       "BJ"},
    {B_1_,          "B1"},
    {Tu_22M3_,      "22"},
    {MiG_25P_,      "25"},
    {MiG_31_,       "31"},
    {Tu_95_,        "95"},
    {Tu_142_,       "Tu"},
    {B_52_,         "52"},
    {A_50_,         "50"},
    {E_3_,          "E3"},
    {S_3A_,         "S3"},
    {S_3R_,         "S3"},
    {E_2C_,         "E2"},
    {C_17_,         "17"},
    {C_130_,        "13"},
    {IL_76_,        "76"},
    {AN_26B_,       "AN"},
    {AN_30M_,       "AN"},
    {KC_10_,        "KC"},
    {KC_135_,       "KC"},
    {IL_78_,        "78"},
    {Su_39_,        "39"},
    {EWR_1L13_,             "S"},
    {EWR_55G6_,             "S"},
    {S300PS_SR_5N66M,       "CS"},
    {S300PS_SR_64H6E,       "BB"},
    {RLO_9C15MT_,           "BD"},
    {RLO_9C19M2_,           "HS"},
    {Buk_SR_9S18M1,         "SD"},
    {Kub_STR_9S91,          "6"},
    {Dog_Ear,               "DE"},
    {Roland_rdr,            "GR"},
    {Patriot_STR_ANMPQ_53,  "PT"},
    {Hawk_SR_ANMPQ_50,      "HA"},
    {S300PS_TR_30N6,        "10"},
    {RLS_5H63C,             "10"},
    {RLS_9C32_1_,           "12"},
    {Hawk_TR_ANMPQ_46,      "HK"},
    {S300V_9A82_,           "12"},
    {S300V_9A83,            "12"},
    {Buk_LN_9A310M1,        "11"},
    {BUK_LL_,               "11"},
    {Osa_9A33,              "8"},
    {Strela_9A35M3,         "13"},
    {Tor_9A331,             "15"},
    {Roland_ADS,            "RO"},
    {Tunguska_2S6,          "S6"},
    {ZSU_23_4_Shilka,       "A"},
    {Gepard,                "A"},
    {Vulcan_M163,           "A"},
    {Kuznecow_,             "SW"},
    {VINSON_,               "48"},
    {MOSCOW_,               "T2"},
    {GROZNY_,               "HN"},
    {AZOV_,                 "TS"},
    {ALBATROS_,             "HP"},
    {AMETYST_,              "SC"},
    {OREL_,                 "HN"},
    {REZKY_,                "TP"},
    {PERRY_,                "49"},
    {OSA_,                  "DT"},
    {MOLNIYA_,              "PS"},
    {SKORY_,                "HN"},
    {SPRUANCE_,             "40"},
    {TICONDEROGA_,          "AE"},
    {BORA_,                 "CD"},
    {BOBRUISK_,             "CD"},
    {VETER_,                "PP"},
    {NEUSTRASH_,            "TP"},
    {MICA_R_,               "M"},
    {P_27AE_,               "M"},
    {P_77_,                 "M"},
    {P_37_,                 "M"},
    {AIM_54_,               "M"},
    {AIM_120_,              "M"},
    {AIM_120C_,             "M"},
    {S125_SR_P_19,          "S"},
    {S125_TR_SNR,           "3"},
}

SoundsPath = "Aircrafts/Cockpits/RWR/"
SoundsPathExpanded = "Aircrafts/Cockpits/RWR/RWRExpanded/"

DefaultSearchSnd = SoundsPath .. "SearchNewUS"


-- sounds for radars
acquisition_sounds = 
{
    {EWR_1L13_,             SoundsPathExpanded .. "EWR"},
    {EWR_55G6_,             SoundsPathExpanded .. "EWR"},
    {S300PS_SR_5N66M,       SoundsPathExpanded .. "FlapLid"},
    {S300PS_SR_64H6E,       SoundsPathExpanded .. "FlapLid"},
    {RLO_9C15MT_,           SoundsPathExpanded .. "SA10"},
    {RLO_9C19M2_,           SoundsPathExpanded .. "SA10"},
    {Buk_SR_9S18M1,         SoundsPathExpanded .. "SnowDrift"},
    {Kub_STR_9S91,          SoundsPathExpanded .. "SA6acq"},
    {Dog_Ear,               SoundsPathExpanded .. "DogEar"},
    {Roland_rdr,            SoundsPathExpanded .. "RolandAcq"},
    {Patriot_STR_ANMPQ_53,  SoundsPathExpanded .. "Patriot"},
    {Hawk_SR_ANMPQ_50,      SoundsPathExpanded .. "HawkAcq"},
    {S300PS_TR_30N6,        SoundsPathExpanded .. "SA10"},
    {RLS_5H63C_,            DefaultSearchSnd},
    {RLS_9C32_1_,           DefaultSearchSnd},
    {Hawk_TR_ANMPQ_46,      SoundsPathExpanded .. "HawkLock"},
    {S300V_9A82_,           SoundsPathExpanded .. "SA10"},
    {S300V_9A83,            SoundsPathExpanded .. "SA10"},
    {Buk_LN_9A310M1,        SoundsPathExpanded .. "SA11acq"},
    {BUK_LL_,               SoundsPathExpanded .. "SA11"},
    {Osa_9A33,              SoundsPathExpanded .. "SA8acq"},
    {Tor_9A331,             SoundsPathExpanded .. "SA15acq"},
    {Roland_ADS,            DefaultSearchSnd},
    {Tunguska_2S6,          SoundsPathExpanded .. "TunguskaAcq"},
    {ZSU_23_4_Shilka,       SoundsPathExpanded .. "GunDishAcq"},
    {Gepard,                DefaultSearchSnd},
    {Vulcan_M163,           DefaultSearchSnd},
	{S125_SR_P_19,          SoundsPathExpanded .. "FlatFace"},
    {S125_TR_SNR,         	SoundsPathExpanded .. "SA3acq"},
    {DEFAULT_TYPE_,         DefaultSearchSnd},
	
	--Air Units
	
	{E_3_,                  SoundsPathExpanded .. "E3"},
	{E_2C_,                 SoundsPathExpanded .. "E2C"},
	{A_50_,                 SoundsPathExpanded .. "A50"},
	{MiG_23_,               SoundsPathExpanded .. "MIG23"},
    {MiG_25P_,              SoundsPathExpanded .. "MIG25"},
	{MiG_23_,               SoundsPathExpanded .. "MIG23"},
    {MiG_29_,               SoundsPathExpanded .. "MIG29"},
    {MIG_29K_,              SoundsPathExpanded .. "MIG29"},
    {MiG_29G_,              SoundsPathExpanded .. "MIG29"},
    {MiG_29C_,              SoundsPathExpanded .. "MIG29"},
    {MiG_31_,               SoundsPathExpanded .. "MIG31"},
	{Su_27_,                SoundsPathExpanded .. "SU29"},
    {Su_33_,                SoundsPathExpanded .. "SU29"},
    {Su_30_,                SoundsPathExpanded .. "SU30"},
    {Su_34_,                SoundsPathExpanded .. "SU34"},
    {Su_24_,                SoundsPathExpanded .. "SU24"},
    {Su_24MR_,              SoundsPathExpanded .. "SU24"},
    {Su_39_,                SoundsPathExpanded .. "SU39"},
    {Mirage_,               SoundsPathExpanded .. "MIRAGE"},
	{F_4E_,                 SoundsPathExpanded .. "F4"},
    {F_5E_,                 SoundsPathExpanded .. "F5"},
	{F_14_,                 SoundsPathExpanded .. "F14"},
    {F_15_,                 SoundsPathExpanded .. "F15"},
    {F_16_,                 SoundsPathExpanded .. "F16"},
    {F_16A_,                SoundsPathExpanded .. "F16"},
	{FA_18_,                SoundsPathExpanded .. "F18"},
    {FA_18C_,               SoundsPathExpanded .. "F18"},
	
	
	--Naval Units
	

	{Kuznecow_,             SoundsPathExpanded .. "KuznecowAcq"},
    {VINSON_,               SoundsPathExpanded .. "VinsonAcq"},
    {MOSCOW_,               SoundsPathExpanded .. "MoscowAcq"},
    {GROZNY_,               SoundsPathExpanded .. "GroznyAcq"},
    {AZOV_,                 DefaultSearchSnd},
    {ALBATROS_,             SoundsPathExpanded .. "AlbatrosAcq"},
    {AMETYST_,              DefaultSearchSnd},
    {OREL_,                 SoundsPathExpanded .. "GroznyAcq"},
    {REZKY_,                SoundsPathExpanded .. "RezkyAcq"},
    {PERRY_,                SoundsPathExpanded .. "PerryAcq"},
    {OSA_,                  DefaultSearchSnd},
    {MOLNIYA_,              SoundsPathExpanded .. "MolniyaAcq"},
    {SKORY_,                SoundsPathExpanded .. "GroznyAcq"},
    {SPRUANCE_,             DefaultSearchSnd},
    {TICONDEROGA_,          SoundsPathExpanded .. "TiconderogaAcq"},
    {BORA_,                 DefaultSearchSnd},
    {BOBRUISK_,             DefaultSearchSnd},
    {VETER_,                DefaultSearchSnd},
    {NEUSTRASH_,            SoundsPathExpanded .. "NeustrashAcq"},	
	
}

DefaultLockSnd = SoundsPath .. "LockNewUS"

lock_sounds = 
{
    {EWR_1L13_,             SoundsPathExpanded .. "EWR"},
    {EWR_55G6_,             SoundsPathExpanded .. "EWR"},
    {S300PS_SR_5N66M,       SoundsPathExpanded .. "FlapLid"},
    {S300PS_SR_64H6E,       SoundsPathExpanded .. "FlapLid"},
    {RLO_9C15MT_,           SoundsPathExpanded .. "SA10"},
    {RLO_9C19M2_,           SoundsPathExpanded .. "SA10"},
    {Buk_SR_9S18M1,         SoundsPathExpanded .. "SnowDrift"},
    {Kub_STR_9S91,          SoundsPathExpanded .. "SA6Lock"},
    {Dog_Ear,               SoundsPathExpanded .. "DogEar"},
    {Roland_rdr,            DefaultLockSnd},
    {Patriot_STR_ANMPQ_53,  SoundsPathExpanded .. "Patriot"},
    {Hawk_SR_ANMPQ_50,      SoundsPathExpanded .. "HawkAcq"},
    {S300PS_TR_30N6,        SoundsPathExpanded .. "SA10"},
    {RLS_5H63C_,            DefaultLockSnd},
    {RLS_9C32_1_,           DefaultLockSnd},
    {Hawk_TR_ANMPQ_46,      SoundsPathExpanded .. "HawkLock"},
    {S300V_9A82_,           SoundsPathExpanded .. "SA10"},
    {S300V_9A83,            SoundsPathExpanded .. "SA10"},
    {Buk_LN_9A310M1,        SoundsPathExpanded .. "SA11"},
    {BUK_LL_,               SoundsPathExpanded .. "SA11"},
    {Osa_9A33,              SoundsPathExpanded .. "SA8lock"},
    {Tor_9A331,             SoundsPathExpanded .. "SA15Lock"},
    {Roland_ADS,            SoundsPathExpanded .. "RolandLock"},
    {Tunguska_2S6,          SoundsPathExpanded .. "TunguskaLock"},
    {ZSU_23_4_Shilka,       SoundsPathExpanded .. "GunDish"},
    {Gepard,                SoundsPathExpanded .. "GepardLock"},
    {Vulcan_M163,           SoundsPathExpanded .. "VulcanLock"},
	{S125_SR_P_19,          SoundsPathExpanded .. "FlatFace"},
    {S125_TR_SNR,         	SoundsPathExpanded .. "SA3lock"},
    {DEFAULT_TYPE_,         DefaultLockSnd},   

    --Naval Units

	{Kuznecow_,             SoundsPathExpanded .. "KuznecowLock"},
    {VINSON_,               SoundsPathExpanded .. "VinsonLock"},
    {MOSCOW_,               SoundsPathExpanded .. "MoscowLock"},
    {GROZNY_,               SoundsPathExpanded .. "GroznyLock"},
    {AZOV_,                 DefaultSearchSnd},
    {ALBATROS_,             SoundsPathExpanded .. "AlbatrosLock"},
    {AMETYST_,              DefaultSearchSnd},
    {OREL_,                 SoundsPathExpanded .. "GroznyLock"},
    {REZKY_,                SoundsPathExpanded .. "RezkyLock"},
    {PERRY_,                SoundsPathExpanded .. "PerryLock"},
    {OSA_,                  DefaultSearchSnd},
    {MOLNIYA_,              SoundsPathExpanded .. "MolniyaLock"},
    {SKORY_,                SoundsPathExpanded .. "GroznyLock"},
    {SPRUANCE_,             DefaultSearchSnd},
    {TICONDEROGA_,          SoundsPathExpanded .. "TiconderogaLock"},
    {BORA_,                 DefaultSearchSnd},
    {BOBRUISK_,             DefaultSearchSnd},
    {VETER_,                DefaultSearchSnd},
    {NEUSTRASH_,            SoundsPathExpanded .. "NeustrashLock"},	
	
	--Missiles
	
	{MICA_R_,               SoundsPathExpanded .. "MICARLock"},
    {P_27AE_,               SoundsPathExpanded .. "P27Lock"},
    {P_77_,                 SoundsPathExpanded .. "P77Lock"},
    {P_37_,                 SoundsPathExpanded .. "P37Lock"},
    {AIM_54_,               SoundsPathExpanded .. "AIM54Lock"},
    {AIM_120_,              SoundsPathExpanded .. "AIM120Lock"},
    {AIM_120C_,             SoundsPathExpanded .. "AIM120CLock"},
}

-- RWR sensors: A10C has four sensors - 2 on nose and 2 in tail
eyes ={}

eyes[1] =
{
    position      = {x = 7.5,y = 0.3,z =  0.2},
    orientation   = {azimuth  = math.rad(45),elevation = math.rad(0.0)},
    field_of_view = math.rad(120) 
}
eyes[2] =
{
    position      = {x = 7.5,y = 0.3,z = -0.2},
    orientation   = {azimuth  = math.rad(-45),elevation = math.rad(0.0)},
    field_of_view = math.rad(120) 
}
eyes[3] =
{
    position      = {x = -8.5,y = 0.0,z =  0.2},
    orientation   = {azimuth  = math.rad(135),elevation = math.rad(0.0)},
    field_of_view = math.rad(120) 
}
eyes[4] =
{
    position      = {x = -8.5,y = 0.0,z =  -0.2},
    orientation   = {azimuth  = math.rad(-135),elevation = math.rad(0.0)},
    field_of_view = math.rad(120) 
}

AN_ALR69V_FAILURE_SENSOR_NOSE_RIGHT = 0
AN_ALR69V_FAILURE_SENSOR_NOSE_LEFT  = 1
AN_ALR69V_FAILURE_SENSOR_TAIL_RIGHT = 2
AN_ALR69V_FAILURE_SENSOR_TAIL_LEFT  = 3
AN_ALR69V_FAILURE_TOTAL         = 4

Damage = {  {Failure = AN_ALR69V_FAILURE_SENSOR_NOSE_RIGHT, Failure_name =  "AN_ALR69V_FAILURE_SENSOR_NOSE_RIGHT", Failure_editor_name = _("AN/ALR-69(V) sensor nose right"),  Element = 0, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
        {Failure = AN_ALR69V_FAILURE_SENSOR_NOSE_LEFT, Failure_name =  "AN_ALR69V_FAILURE_SENSOR_NOSE_LEFT", Failure_editor_name = _("AN/ALR-69(V) sensor tail right"),  Element = 0, Integrity_Treshold = 0.25, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
        {Failure = AN_ALR69V_FAILURE_SENSOR_TAIL_RIGHT, Failure_name =  "AN_ALR69V_FAILURE_SENSOR_TAIL_RIGHT", Failure_editor_name = _("AN/ALR-69(V) sensor tail left"),  Element = 55, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
        {Failure = AN_ALR69V_FAILURE_SENSOR_TAIL_LEFT, Failure_name =  "AN_ALR69V_FAILURE_SENSOR_TAIL_LEFT", Failure_editor_name = _("AN/ALR-69(V) sensor nose left"),  Element = 55, Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300},
        {Failure = AN_ALR69V_FAILURE_TOTAL, Failure_name =  "AN_ALR69V_FAILURE_TOTAL", Failure_editor_name = _("AN/ALR-69(V) total failure"),  Element = 4, Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*300}}

need_to_be_closed = true -- close lua state after initialization 
